<?php $__env->startSection('title', 'Leave Report'); ?>
<?php $__env->startSection('page-title', 'Leave Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Summary Stats -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="stat-card primary">
                <div class="text-center">
                    <h6 class="text-muted mb-1">Total Requests</h6>
                    <h3 class="mb-0"><?php echo e($summary['total_requests']); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card success">
                <div class="text-center">
                    <h6 class="text-muted mb-1">Approved</h6>
                    <h3 class="mb-0"><?php echo e($summary['approved']); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card warning">
                <div class="text-center">
                    <h6 class="text-muted mb-1">Pending</h6>
                    <h3 class="mb-0"><?php echo e($summary['pending']); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card danger">
                <div class="text-center">
                    <h6 class="text-muted mb-1">Total Days</h6>
                    <h3 class="mb-0"><?php echo e($summary['total_days']); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <div class="table-card">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Leave Report - <?php echo e($year); ?></h5>
            <div>
                <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back
                </a>
                <a href="<?php echo e(route('reports.leave.pdf', request()->all())); ?>" class="btn btn-danger">
                    <i class="bi bi-file-pdf"></i> Export PDF
                </a>
                <button onclick="window.print()" class="btn btn-primary">
                    <i class="bi bi-printer"></i> Print
                </button>
            </div>
        </div>

        <!-- Filters -->
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-6">
                <label class="form-label">Year</label>
                <select name="year" class="form-select">
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Department</label>
                <select name="department" class="form-select">
                    <option value="">All Departments</option>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dept->id); ?>" <?php echo e(request('department') == $dept->id ? 'selected' : ''); ?>>
                            <?php echo e($dept->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">Filter</button>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-bordered table-sm">
                <thead class="table-light">
                    <tr>
                        <th>Employee</th>
                        <th>Leave Type</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Days</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $leaves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leave): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($leave->employee->full_name); ?></td>
                            <td><?php echo e($leave->leaveType->name); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($leave->start_date)->format('M d, Y')); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($leave->end_date)->format('M d, Y')); ?></td>
                            <td><?php echo e($leave->number_of_days); ?></td>
                            <td>
                                <span class="badge <?php echo e($leave->status == 'approved' ? 'bg-success' : ($leave->status == 'pending' ? 'bg-warning' : 'bg-danger')); ?>">
                                    <?php echo e(ucfirst($leave->status)); ?>

                                </span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-3 text-muted">No leave records found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/reports/leave.blade.php ENDPATH**/ ?>