<?php $__env->startSection('title', 'Manage Training Sessions'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Manage Training Sessions</h1>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingSession::class)): ?>
                    <a href="<?php echo e(route('training.sessions.create')); ?>" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Schedule Session
                    </a>
                <?php endif; ?>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('training.sessions.index')); ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <select name="program" class="form-select">
                                    <option value="">All Programs</option>
                                    <?php $__currentLoopData = $programs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($program->id); ?>" <?php echo e(request('program') == $program->id ? 'selected' : ''); ?>>
                                            <?php echo e($program->title); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="status" class="form-select">
                                    <option value="">All Status</option>
                                    <option value="scheduled" <?php echo e(request('status') == 'scheduled' ? 'selected' : ''); ?>>Scheduled</option>
                                    <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>>In Progress</option>
                                    <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                    <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="from_date" class="form-control" value="<?php echo e(request('from_date')); ?>" placeholder="From Date">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="to_date" class="form-control" value="<?php echo e(request('to_date')); ?>" placeholder="To Date">
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-outline-secondary" type="submit">
                                    <i class="bi bi-search"></i> Filter
                                </button>
                                <a href="<?php echo e(route('training.sessions.index')); ?>" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Sessions Table -->
            <div class="card">
                <div class="card-body">
                    <?php if($sessions->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Session Code</th>
                                        <th>Program</th>
                                        <th>Date & Time</th>
                                        <th>Location</th>
                                        <th>Instructor</th>
                                        <th>Enrollments</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($session->session_code); ?></strong>
                                            </td>
                                            <td>
                                                <div>
                                                    <strong><?php echo e($session->program->title); ?></strong><br>
                                                    <small class="text-muted"><?php echo e($session->program->category->name); ?></small>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    <strong><?php echo e($session->start_datetime->format('M j, Y')); ?></strong><br>
                                                    <small class="text-muted">
                                                        <?php echo e($session->start_datetime->format('g:i A')); ?> - <?php echo e($session->end_datetime->format('g:i A')); ?>

                                                    </small>
                                                </div>
                                            </td>
                                            <td>
                                                <?php if($session->location): ?>
                                                    <i class="bi bi-map-marker-alt"></i> <?php echo e($session->location); ?>

                                                <?php elseif($session->virtual_meeting_link): ?>
                                                    <i class="bi bi-video"></i> Virtual
                                                <?php else: ?>
                                                    <span class="text-muted">TBD</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($session->instructor): ?>
                                                    <?php echo e($session->instructor->name); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">Not assigned</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="badge badge-info"><?php echo e($session->enrollments->count()); ?></span>
                                                <?php if($session->max_participants): ?>
                                                    / <?php echo e($session->max_participants); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="badge badge-<?php echo e($session->status == 'scheduled' ? 'primary' : 
                                                    ($session->status == 'in_progress' ? 'warning' : 
                                                    ($session->status == 'completed' ? 'success' : 'danger'))); ?>">
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $session->status))); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $session)): ?>
                                                        <a href="<?php echo e(route('training.sessions.show', $session)); ?>" class="btn btn-sm btn-outline-primary">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $session)): ?>
                                                        <?php if($session->status == 'scheduled'): ?>
                                                            <a href="<?php echo e(route('training.sessions.edit', $session)); ?>" class="btn btn-sm btn-outline-secondary">
                                                                <i class="bi bi-pencil"></i>
                                                            </a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-center">
                            <?php echo e($sessions->withQueryString()->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-calendar-times fa-3x text-muted mb-3"></i>
                            <h4>No Training Sessions Found</h4>
                            <p class="text-muted">No training sessions match your current filters.</p>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\TrainingSession::class)): ?>
                                <a href="<?php echo e(route('training.sessions.create')); ?>" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> Schedule First Session
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/training/sessions/index.blade.php ENDPATH**/ ?>