<?php $__env->startSection('title', 'Payroll Report'); ?>
<?php $__env->startSection('page-title', 'Payroll Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Summary Stats -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="stat-card primary">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-people"></i>
                    </div>
                    <h6 class="text-muted mb-1">Employees</h6>
                    <h3 class="mb-0"><?php echo e($summary['total_employees']); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card success">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-cash-stack"></i>
                    </div>
                    <h6 class="text-muted mb-1">Total Gross</h6>
                    <h3 class="mb-0">KES <?php echo e(number_format($summary['total_gross'], 0)); ?></h3>
                    <small class="text-success">Avg: <?php echo e(number_format($summary['avg_gross'], 0)); ?></small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card danger">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-dash-circle"></i>
                    </div>
                    <h6 class="text-muted mb-1">Total Deductions</h6>
                    <h3 class="mb-0">KES <?php echo e(number_format($summary['total_deductions'], 0)); ?></h3>
                    <small class="text-danger">Avg: <?php echo e(number_format($summary['avg_deductions'], 0)); ?></small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card info">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-wallet2"></i>
                    </div>
                    <h6 class="text-muted mb-1">Total Net</h6>
                    <h3 class="mb-0">KES <?php echo e(number_format($summary['total_net'], 0)); ?></h3>
                    <small class="text-info">Avg: <?php echo e(number_format($summary['avg_net'], 0)); ?></small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card warning">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-check-circle"></i>
                    </div>
                    <h6 class="text-muted mb-1">Paid</h6>
                    <h3 class="mb-0"><?php echo e($summary['paid']); ?></h3>
                    <small class="text-success"><?php echo e($summary['payment_completion_rate']); ?>% complete</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card secondary">
                <div class="text-center">
                    <div class="stat-icon mx-auto mb-2" style="width: 50px; height: 50px;">
                        <i class="bi bi-clock"></i>
                    </div>
                    <h6 class="text-muted mb-1">Pending</h6>
                    <h3 class="mb-0"><?php echo e($summary['pending']); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Progress -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="table-card">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h2 class="text-primary mb-1"><?php echo e($summary['payment_completion_rate']); ?>%</h2>
                            <p class="text-muted mb-0">Payment Completion Rate</p>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="progress" style="height: 20px;">
                            <div class="progress-bar bg-success" style="width: <?php echo e($summary['payment_completion_rate']); ?>%"></div>
                        </div>
                        <div class="d-flex justify-content-between mt-2">
                            <small class="text-success">Paid: <?php echo e($summary['paid']); ?> employees</small>
                            <small class="text-warning">Pending: <?php echo e($summary['pending']); ?> employees</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Department Breakdown -->
    <?php if(isset($departmentBreakdown) && $departmentBreakdown->count() > 0): ?>
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="table-card">
                <h6 class="mb-3">Department-wise Payroll Breakdown</h6>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead class="table-light">
                            <tr>
                                <th>Department</th>
                                <th>Employees</th>
                                <th>Total Gross</th>
                                <th>Total Net</th>
                                <th>Avg Net</th>
                                <th>Paid</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $departmentBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($dept['name']); ?></td>
                                <td><?php echo e($dept['employee_count']); ?></td>
                                <td>KES <?php echo e(number_format($dept['total_gross'], 0)); ?></td>
                                <td><strong>KES <?php echo e(number_format($dept['total_net'], 0)); ?></strong></td>
                                <td>KES <?php echo e(number_format($dept['avg_net'], 0)); ?></td>
                                <td>
                                    <span class="badge bg-success"><?php echo e($dept['paid_count']); ?></span>
                                    <small class="text-muted">/ <?php echo e($dept['employee_count']); ?></small>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="table-card">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <?php
                $monthLabel = (is_int($month) || is_string($month)) ? ($months[$month] ?? '') : '';
            ?>
            <h5 class="mb-0">Payroll Report - <?php echo e($monthLabel); ?> <?php echo e($year); ?></h5>
            <div>
                <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back
                </a>
                <a href="<?php echo e(route('reports.payroll.pdf', request()->all())); ?>" class="btn btn-danger">
                    <i class="bi bi-file-pdf"></i> Export PDF
                </a>
                <button onclick="window.print()" class="btn btn-primary">
                    <i class="bi bi-printer"></i> Print
                </button>
            </div>
        </div>

        <!-- Filters -->
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-4">
                <label class="form-label">Month</label>
                <select name="month" class="form-select">
                    <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($m); ?>" <?php echo e($month == $m ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Year</label>
                <select name="year" class="form-select">
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Department</label>
                <select name="department" class="form-select">
                    <option value="">All Departments</option>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dept->id); ?>" <?php echo e(request('department') == $dept->id ? 'selected' : ''); ?>>
                            <?php echo e($dept->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">Filter</button>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-bordered table-sm">
                <thead class="table-light">
                    <tr>
                        <th>Employee</th>
                        <th>Basic</th>
                        <th>Allowances</th>
                        <th>Gross</th>
                        <th>Deductions</th>
                        <th>Net Salary</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $payrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($payroll->employee->full_name); ?></td>
                            <td>KES <?php echo e(number_format($payroll->basic_salary, 0)); ?></td>
                            <td>KES <?php echo e(number_format($payroll->total_allowances, 0)); ?></td>
                            <td>KES <?php echo e(number_format($payroll->gross_salary, 0)); ?></td>
                            <td>KES <?php echo e(number_format($payroll->total_deductions, 0)); ?></td>
                            <td><strong>KES <?php echo e(number_format($payroll->net_salary, 0)); ?></strong></td>
                            <td>
                                <span class="badge <?php echo e($payroll->status == 'paid' ? 'bg-success' : 'bg-warning'); ?>">
                                    <?php echo e(ucfirst($payroll->status)); ?>

                                </span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-3 text-muted">No payroll records found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/reports/payroll.blade.php ENDPATH**/ ?>