<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Interview Confirmation</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                
                <?php if(session('info')): ?>
                <div class="alert alert-info"><?php echo e(session('info')); ?></div>
                <?php endif; ?>

                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-calendar-event"></i> Interview Invitation</h5>
                    </div>
                    <div class="card-body">
                        <h4 class="mb-3"><?php echo e($interview->application->jobPosting->title); ?></h4>
                        <p class="text-muted"><?php echo e($interview->application->jobPosting->organization->name); ?></p>

                        <div class="alert alert-info">
                            <h6><i class="bi bi-info-circle"></i> Interview Details</h6>
                            <p class="mb-1"><strong>Date & Time:</strong> <?php echo e($interview->scheduled_at->format('l, F j, Y \a\t g:i A')); ?></p>
                            <?php if($interview->location): ?>
                            <p class="mb-1"><strong>Location:</strong> <?php echo e($interview->location); ?></p>
                            <?php endif; ?>
                            <?php if($interview->meeting_link): ?>
                            <p class="mb-1"><strong>Meeting Link:</strong> <a href="<?php echo e($interview->meeting_link); ?>" target="_blank">Join Virtual Meeting</a></p>
                            <?php endif; ?>
                            <p class="mb-0"><strong>Interviewer:</strong> <?php echo e($interview->interviewer->name); ?></p>
                        </div>

                        <?php if($interview->candidate_response === 'pending'): ?>
                        <div class="d-grid gap-2">
                            <form method="POST" action="<?php echo e(route('interview.confirm', $interview->confirmation_token)); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-success btn-lg w-100">
                                    <i class="bi bi-check-circle"></i> Confirm Attendance
                                </button>
                            </form>
                            
                            <button type="button" class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#declineModal">
                                <i class="bi bi-x-circle"></i> Decline Interview
                            </button>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-<?php echo e($interview->candidate_response === 'confirmed' ? 'success' : 'warning'); ?>">
                            <strong>Status:</strong> You have <?php echo e($interview->candidate_response); ?> this interview.
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Decline Modal -->
    <div class="modal fade" id="declineModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('interview.decline', $interview->confirmation_token)); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title">Decline Interview</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to decline this interview?</p>
                        <div class="mb-3">
                            <label class="form-label">Reason (Optional)</label>
                            <textarea class="form-control" name="reason" rows="3" placeholder="Let us know why..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Decline Interview</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/candidate/interview/confirm.blade.php ENDPATH**/ ?>