<?php $__env->startSection('title', $title ?? 'Validation Error'); ?>
<?php $__env->startSection('code', '422'); ?>

<?php $__env->startSection('content'); ?>
    <div class="error-icon text-warning">
        <i class="bi bi-exclamation-diamond"></i>
    </div>
    
    <p class="error-message">
        <?php echo e($message ?? "The information you provided couldn't be processed. Please check your input and try again."); ?>

    </p>

    <div class="error-details">
        <h6><i class="bi bi-clipboard-check me-2"></i>Data Validation Failed</h6>
        <p>Some of the information you submitted doesn't meet our requirements. This helps ensure data quality and system security.</p>
    </div>

    <div class="error-actions">
        <a href="javascript:history.back()" class="btn-primary-custom">
            <i class="bi bi-arrow-left"></i>
            Go Back & Fix
        </a>
        
        <?php if(auth()->guard()->check()): ?>
            <a href="<?php echo e(route('dashboard')); ?>" class="btn-secondary-custom">
                <i class="bi bi-house"></i>
                Go to Dashboard
            </a>
        <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="btn-secondary-custom">
                <i class="bi bi-box-arrow-in-right"></i>
                Login
            </a>
        <?php endif; ?>
        
        <a href="mailto:support@qayahrms.com" class="btn-success-custom">
            <i class="bi bi-life-preserver"></i>
            Get Help
        </a>
    </div>

    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-lightbulb me-1"></i>
            <strong>Tip:</strong> Check for required fields, correct formats (email, phone), and valid date ranges.
        </small>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('errors.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/errors/422.blade.php ENDPATH**/ ?>