<?php $__env->startSection('title', 'Import Employees'); ?>
<?php $__env->startSection('page-title', 'Import Employees'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('employees.index')); ?>">Employees</a></li>
                <li class="breadcrumb-item active">Import</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-upload"></i> Import Employees from Excel/CSV</h5>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="bi bi-exclamation-triangle"></i> <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <div class="alert alert-info">
                        <h6 class="alert-heading"><i class="bi bi-info-circle"></i> Instructions</h6>
                        <ol class="mb-0">
                            <li>Download the import template using the button below</li>
                            <li>Fill in the employee data in the template</li>
                            <li>Save the file and upload it using the form below</li>
                            <li>Make sure the email addresses are unique</li>
                            <li>Required fields: first_name, last_name, email, department, position</li>
                        </ol>
                    </div>

                    <div class="mb-4">
                        <a href="<?php echo e(route('employees.template')); ?>" class="btn btn-success btn-lg w-100">
                            <i class="bi bi-download"></i> Download Import Template
                        </a>
                    </div>

                    <form action="<?php echo e(route('employees.import')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="file" class="form-label">Choose Excel/CSV File</label>
                            <input type="file" name="file" id="file" class="form-control <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept=".xlsx,.xls,.csv" required>
                            <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-text">Accepted formats: XLSX, XLS, CSV (Max: 2MB)</div>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-upload"></i> Import Employees
                            </button>
                            <a href="<?php echo e(route('employees.index')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card shadow-sm mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-table"></i> Template Fields Reference</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Field</th>
                                    <th>Required</th>
                                    <th>Example</th>
                                    <th>Notes</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>employee_code</td>
                                    <td><span class="badge bg-secondary">Optional</span></td>
                                    <td>EMP0001</td>
                                    <td>Auto-generated if empty</td>
                                </tr>
                                <tr>
                                    <td>first_name</td>
                                    <td><span class="badge bg-danger">Required</span></td>
                                    <td>John</td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>last_name</td>
                                    <td><span class="badge bg-danger">Required</span></td>
                                    <td>Doe</td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>email</td>
                                    <td><span class="badge bg-danger">Required</span></td>
                                    <td>john.doe@example.com</td>
                                    <td>Must be unique</td>
                                </tr>
                                <tr>
                                    <td>phone</td>
                                    <td><span class="badge bg-secondary">Optional</span></td>
                                    <td>+1234567890</td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>department</td>
                                    <td><span class="badge bg-danger">Required</span></td>
                                    <td>IT Department</td>
                                    <td>Will be created if doesn't exist</td>
                                </tr>
                                <tr>
                                    <td>position</td>
                                    <td><span class="badge bg-danger">Required</span></td>
                                    <td>Software Developer</td>
                                    <td>Will be created if doesn't exist</td>
                                </tr>
                                <tr>
                                    <td>join_date</td>
                                    <td><span class="badge bg-secondary">Optional</span></td>
                                    <td>2025-01-01</td>
                                    <td>Format: YYYY-MM-DD</td>
                                </tr>
                                <tr>
                                    <td>salary</td>
                                    <td><span class="badge bg-secondary">Optional</span></td>
                                    <td>50000</td>
                                    <td>Numeric value</td>
                                </tr>
                                <tr>
                                    <td>status</td>
                                    <td><span class="badge bg-secondary">Optional</span></td>
                                    <td>active</td>
                                    <td>active, inactive, on_leave, terminated</td>
                                </tr>
                                <tr>
                                    <td>gender</td>
                                    <td><span class="badge bg-secondary">Optional</span></td>
                                    <td>male</td>
                                    <td>male, female, other</td>
                                </tr>
                                <tr>
                                    <td>password</td>
                                    <td><span class="badge bg-secondary">Optional</span></td>
                                    <td>password123</td>
                                    <td>Default: password123</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/employees/import.blade.php ENDPATH**/ ?>