<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Position Closed - <?php echo e($jobPosting->organization->name); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <div class="text-warning mb-4">
                            <i class="bi bi-exclamation-triangle-fill" style="font-size: 4rem;"></i>
                        </div>
                        
                        <h2 class="text-warning mb-3">Position No Longer Available</h2>
                        
                        <p class="text-muted mb-4">
                            The <strong><?php echo e($jobPosting->title); ?></strong> position at <?php echo e($jobPosting->organization->name); ?> is no longer accepting applications.
                        </p>

                        <div class="bg-light p-3 rounded mb-4">
                            <h6 class="mb-2">Position Details:</h6>
                            <div class="row text-start">
                                <div class="col-sm-6">
                                    <small class="text-muted">Position:</small><br>
                                    <strong><?php echo e($jobPosting->title); ?></strong>
                                </div>
                                <div class="col-sm-6">
                                    <small class="text-muted">Department:</small><br>
                                    <strong><?php echo e($jobPosting->department->name ?? 'N/A'); ?></strong>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Location:</small><br>
                                    <strong><?php echo e($jobPosting->location); ?></strong>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Status:</small><br>
                                    <span class="badge bg-danger"><?php echo e(ucfirst($jobPosting->status)); ?></span>
                                </div>
                            </div>
                        </div>

                        <?php if($jobPosting->closes_at && $jobPosting->closes_at->isPast()): ?>
                            <div class="alert alert-info">
                                <i class="bi bi-calendar-x"></i>
                                This position closed on <strong><?php echo e($jobPosting->closes_at->format('M d, Y')); ?></strong>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle"></i>
                                This position has been closed by the employer.
                            </div>
                        <?php endif; ?>

                        <div class="mt-4">
                            <p class="text-muted">
                                <strong>Looking for other opportunities?</strong><br>
                                Check back later or visit our careers page for other open positions.
                            </p>
                            
                            <?php
                                $websiteUrl = $jobPosting->organization->company_website ?? config('app.url');
                            ?>
                            
                            <a href="<?php echo e($websiteUrl); ?>" class="btn btn-primary">
                                <i class="bi bi-globe"></i> Visit Our Website
                            </a>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <p class="text-muted small">
                        <i class="bi bi-building"></i>
                        <?php echo e($jobPosting->organization->name); ?> - Human Resources
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/recruitment/public/closed.blade.php ENDPATH**/ ?>