<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['organization' => null, 'usage' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['organization' => null, 'usage' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    if ($usage === null && $organization !== null) {
        $usageService = app(\App\Services\UsageTrackingService::class);
        $usage = $usageService->getUsageSummary($organization);
    }
?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-speedometer2"></i> Resource Usage</h5>
    </div>
    <div class="card-body">
        <?php if($usage): ?>
        <?php $__currentLoopData = $usage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metric => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-4">
                <div class="d-flex justify-content-between mb-2">
                    <span class="fw-bold"><?php echo e(ucfirst($metric)); ?></span>
                    <span>
                        <?php echo e($data['current']); ?> / 
                        <?php if($data['unlimited'] ?? false): ?>
                            <span class="text-success">Unlimited</span>
                        <?php else: ?>
                            <?php echo e($data['limit']); ?>

                        <?php endif; ?>
                    </span>
                </div>
                
                <?php if(!($data['unlimited'] ?? false)): ?>
                    <div class="progress" style="height: 20px;">
                        <div class="progress-bar 
                            <?php if($data['percentage'] >= 100): ?> bg-danger
                            <?php elseif($data['percentage'] >= 90): ?> bg-warning
                            <?php else: ?> bg-success
                            <?php endif; ?>" 
                            role="progressbar" 
                            style="width: <?php echo e(min($data['percentage'], 100)); ?>%"
                            aria-valuenow="<?php echo e($data['percentage']); ?>" 
                            aria-valuemin="0" 
                            aria-valuemax="100">
                            <?php echo e(round($data['percentage'], 1)); ?>%
                        </div>
                    </div>
                    
                    <?php if($data['percentage'] >= 100): ?>
                        <small class="text-danger">
                            <i class="bi bi-exclamation-triangle"></i> Limit reached. 
                            <?php if($organization): ?>
                            <a href="<?php echo e(route('subscription.plans')); ?>">Upgrade plan</a>
                            <?php endif; ?>
                        </small>
                    <?php elseif($data['percentage'] >= 90): ?>
                        <small class="text-warning">
                            <i class="bi bi-exclamation-circle"></i> Approaching limit. 
                            <?php if($organization): ?>
                            <a href="<?php echo e(route('subscription.plans')); ?>">Consider upgrading</a>
                            <?php endif; ?>
                        </small>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <p class="text-muted">No usage data available.</p>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/components/subscription-usage.blade.php ENDPATH**/ ?>