<?php $__env->startSection('title', 'Bulk Generate P9 Forms'); ?>
<?php $__env->startSection('page-title', 'Bulk Generate P9 Forms'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('p9-forms.index')); ?>">P9 Forms</a></li>
                <li class="breadcrumb-item active">Bulk Generate</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">Generate P9 Forms for Multiple Employees</h5>

                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i>
                    <strong>Bulk P9 Generation:</strong> Select employees and tax year to generate P9 forms. 
                    Only employees with complete payroll records for the selected year will be processed.
                </div>

                <form action="<?php echo e(route('p9-forms.bulk-generate')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="year" class="form-label">Tax Year <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="year" name="year" required>
                                <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year); ?>" <?php echo e(old('year', now()->year - 1) == $year ? 'selected' : ''); ?>>
                                        <?php echo e($year); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <small class="text-muted">Select the tax year for P9 form generation</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Filter Options</label>
                            <div class="d-flex gap-2">
                                <button type="button" class="btn btn-outline-primary btn-sm" onclick="selectAll()">
                                    <i class="bi bi-check-all"></i> Select All
                                </button>
                                <button type="button" class="btn btn-outline-secondary btn-sm" onclick="selectNone()">
                                    <i class="bi bi-x-square"></i> Select None
                                </button>
                                <button type="button" class="btn btn-outline-success btn-sm" onclick="selectEligible()">
                                    <i class="bi bi-shield-check"></i> Select Eligible Only
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="50">
                                        <input type="checkbox" id="select-all" class="form-check-input">
                                    </th>
                                    <th>Employee</th>
                                    <th>Department</th>
                                    <th>KRA PIN</th>
                                    <th>Basic Salary</th>
                                    <th>P9 Status</th>
                                    <th>Eligibility</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="employee-row" data-eligible="<?php echo e($employee->hasCompleteKraInfo() && $employee->effective_basic_salary > 0 ? 'true' : 'false'); ?>">
                                        <td>
                                            <input type="checkbox" name="employee_ids[]" value="<?php echo e($employee->id); ?>" 
                                                   class="form-check-input employee-checkbox">
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if($employee->photo): ?>
                                                    <img src="<?php echo e(asset('storage/' . $employee->photo)); ?>"
                                                         alt="<?php echo e($employee->full_name); ?>"
                                                         class="rounded-circle me-2"
                                                         style="width: 32px; height: 32px; object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center me-2"
                                                         style="width: 32px; height: 32px; font-size: 12px;">
                                                        <?php echo e(substr($employee->first_name, 0, 1)); ?><?php echo e(substr($employee->last_name, 0, 1)); ?>

                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <strong><?php echo e($employee->full_name); ?></strong><br>
                                                    <small class="text-muted"><?php echo e($employee->employee_code); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($employee->department->name ?? 'N/A'); ?></td>
                                        <td>
                                            <?php if($employee->kra_pin): ?>
                                                <code><?php echo e($employee->kra_pin); ?></code>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark">Not Set</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($employee->effective_basic_salary > 0): ?>
                                                <strong>KES <?php echo e(number_format($employee->effective_basic_salary, 2)); ?></strong>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark">Not Set</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php
                                                $hasP9 = $employee->p9Forms()->where('year', old('year', now()->year - 1))->exists();
                                            ?>
                                            <?php if($hasP9): ?>
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle"></i> Generated
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">
                                                    <i class="bi bi-dash-circle"></i> Not Generated
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($employee->hasCompleteKraInfo() && $employee->effective_basic_salary > 0): ?>
                                                <span class="badge bg-success" title="Ready for P9 generation">
                                                    <i class="bi bi-check-circle"></i> Eligible
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark" title="Missing KRA PIN, NHIF, NSSF, or Basic Salary">
                                                    <i class="bi bi-exclamation-triangle"></i> Incomplete
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <i class="bi bi-people" style="font-size: 48px; color: #ccc;"></i>
                                            <p class="text-muted mt-3 mb-0">No active employees found</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if($employees->count() > 0): ?>
                        <div class="alert alert-warning mt-4">
                            <h6><i class="bi bi-exclamation-triangle me-2"></i>Important Notes:</h6>
                            <ul class="mb-0">
                                <li>Only employees with complete KRA information and payroll records will be processed</li>
                                <li>Existing P9 forms for the selected year will be updated</li>
                                <li>Employees must have payroll records for the entire selected year</li>
                                <li>Generated P9 forms can be downloaded individually or in bulk</li>
                            </ul>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-success btn-lg" id="generate-btn" disabled>
                                <i class="bi bi-files"></i> Generate P9 Forms for Selected Employees
                            </button>
                            <a href="<?php echo e(route('p9-forms.index')); ?>" class="btn btn-secondary btn-lg">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Handle select all checkbox
    document.getElementById('select-all').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.employee-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
        updateGenerateButton();
    });

    // Handle individual checkboxes
    document.querySelectorAll('.employee-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            updateSelectAllCheckbox();
            updateGenerateButton();
        });
    });

    // Select all function
    function selectAll() {
        const checkboxes = document.querySelectorAll('.employee-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = true;
        });
        updateSelectAllCheckbox();
        updateGenerateButton();
    }

    // Select none function
    function selectNone() {
        const checkboxes = document.querySelectorAll('.employee-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = false;
        });
        updateSelectAllCheckbox();
        updateGenerateButton();
    }

    // Select eligible only function
    function selectEligible() {
        const rows = document.querySelectorAll('.employee-row');
        rows.forEach(row => {
            const checkbox = row.querySelector('.employee-checkbox');
            const isEligible = row.getAttribute('data-eligible') === 'true';
            checkbox.checked = isEligible;
        });
        updateSelectAllCheckbox();
        updateGenerateButton();
    }

    // Update select all checkbox state
    function updateSelectAllCheckbox() {
        const checkboxes = document.querySelectorAll('.employee-checkbox');
        const selectAllCheckbox = document.getElementById('select-all');
        const checkedCount = document.querySelectorAll('.employee-checkbox:checked').length;
        
        if (checkedCount === 0) {
            selectAllCheckbox.indeterminate = false;
            selectAllCheckbox.checked = false;
        } else if (checkedCount === checkboxes.length) {
            selectAllCheckbox.indeterminate = false;
            selectAllCheckbox.checked = true;
        } else {
            selectAllCheckbox.indeterminate = true;
        }
    }

    // Update generate button state
    function updateGenerateButton() {
        const checkedCount = document.querySelectorAll('.employee-checkbox:checked').length;
        const generateBtn = document.getElementById('generate-btn');
        
        if (checkedCount > 0) {
            generateBtn.disabled = false;
            generateBtn.innerHTML = `<i class="bi bi-files"></i> Generate P9 Forms for ${checkedCount} Employee${checkedCount > 1 ? 's' : ''}`;
        } else {
            generateBtn.disabled = true;
            generateBtn.innerHTML = '<i class="bi bi-files"></i> Generate P9 Forms for Selected Employees';
        }
    }

    // Initialize button state
    updateGenerateButton();
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/p9-forms/bulk-create.blade.php ENDPATH**/ ?>