<?php $__env->startSection('title', 'Messages - ' . $application->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <a href="<?php echo e(route('job-postings.show', $application->job_posting_id)); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Applications
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-chat-dots"></i> Messages with <?php echo e($application->full_name); ?></h5>
                </div>
                <div class="card-body">
                    <div class="mb-3 pb-3 border-bottom">
                        <h6><?php echo e($application->jobPosting->title); ?></h6>
                        <p class="text-muted small mb-0">
                            <i class="bi bi-envelope"></i> <?php echo e($application->email); ?> · 
                            <i class="bi bi-phone"></i> <?php echo e($application->phone); ?>

                        </p>
                    </div>

                    <div class="messages-container" style="max-height: 500px; overflow-y: auto;">
                        <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="message mb-3 <?php echo e($message->isFromCandidate() ? 'text-start' : 'text-end'); ?>">
                            <div class="d-inline-block" style="max-width: 75%;">
                                <div class="card <?php echo e($message->isFromCandidate() ? 'bg-light' : 'bg-primary text-white'); ?>">
                                    <div class="card-body py-2 px-3">
                                        <p class="mb-1"><?php echo e($message->message); ?></p>
                                        <small class="<?php echo e($message->isFromCandidate() ? 'text-muted' : 'text-white-50'); ?>">
                                            <?php if($message->isFromCandidate()): ?>
                                                <i class="bi bi-person"></i> <?php echo e($application->full_name); ?>

                                            <?php else: ?>
                                                <i class="bi bi-person-badge"></i> <?php echo e($message->sender->name ?? 'You'); ?>

                                            <?php endif; ?>
                                            · <?php echo e($message->created_at->diffForHumans()); ?>

                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center text-muted py-5">
                            <i class="bi bi-chat-dots fs-1"></i>
                            <p class="mt-2">No messages yet. Start a conversation below!</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-send"></i> Send Message</h6>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('applications.messages.store', $application)); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <textarea class="form-control" name="message" rows="4" 
                                      placeholder="Type your message to the candidate..." required maxlength="2000"><?php echo e(old('message')); ?></textarea>
                            <div class="form-text">Maximum 2000 characters. Candidate will receive an email notification.</div>
                            <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-send"></i> Send Message
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h6 class="mb-0"><i class="bi bi-info-circle"></i> Application Info</h6>
                </div>
                <div class="card-body">
                    <p><strong>Status:</strong> <span class="badge bg-primary"><?php echo e(ucfirst($application->status)); ?></span></p>
                    <p><strong>Applied:</strong> <?php echo e($application->applied_at->format('M d, Y')); ?></p>
                    <p><strong>Email:</strong> <?php echo e($application->email); ?></p>
                    <p><strong>Phone:</strong> <?php echo e($application->phone); ?></p>
                    <a href="<?php echo e(route('applications.cv.download', $application)); ?>" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-download"></i> Download CV
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    const container = document.querySelector('.messages-container');
    if (container) {
        container.scrollTop = container.scrollHeight;
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/drew/Desktop/Qaya/open source/qaya-hr/resources/views/recruitment/applications/messages.blade.php ENDPATH**/ ?>